# Evaluation semantics

## Single equation

Assume we have given the following definition:
~~~
f x = x + 1
~~~

Then the expression `f (f 13)` is evaluated in this way:

~~~
f (f 13)
f (13 + 1)        because f 13 = 13 + 1
f 14
14 + 1            because f 14 = 14 + 1
15
~~~

## Multiple equations

If we have a more complicated function definition:
~~~
fib 1 = 1
fib 2 = 1
fib n = fib (n-1) + fib (n-2)
~~~

the expression `fib 4` is evaluated as

 ~~~
fib 4
fib (4-1) + fib (4-2)              because fib 4 = fib (4-1) + fib (4-2)
fib 3 + fib 2
(fib (3-1) + fib (3-2)) + fib 2    because fib 3 = fib (3-1) + fib (3-2)
fib 2 + fib 1 + fib 2              because fib 3 = fib (3-1) + fib (3-2)
1 + fib 1 + fib 2                  because fib 2 = 1
1 + 1 + fib 2                      because fib 1 = 1
2 + fib 2     
2 + 1                              because fib 2 = 1
3
 ~~~
